/*____________________________________________________________________________
        Copyright (C) 2000 Networks Associates Technology, Inc.
        All rights reserved.

        $Id: CLDAPPGPKeyServer.h,v 1.2 2000/07/10 22:05:00 dallen Exp $
____________________________________________________________________________*/
#ifndef Included_CLDAPPGPKeyServer_h	/* [ */
#define Included_CLDAPPGPKeyServer_h


#include "pgpSockets.h"
#include "CKeyServer.h"
#include "pgpLDAP.h"
#include "pgpKeyServer.h"


class CLDAPPGPKeyServer : public CKeyServer
{
public:
							CLDAPPGPKeyServer(
								PGPContextRef					inContext,
								const char *					inHostName,
								PGPUInt32						inHostAddress,
								PGPUInt16						inHostPort,
								PGPKeyServerProtocol			inType,
								PGPKeyServerClass				inClass,
								PGPKeyServerAccessType			inAccessType );
	virtual					~CLDAPPGPKeyServer();
	
	virtual void			Cancel();

	virtual void			Open( PGPtlsSessionRef inTLSSession );
	virtual void			Close();

	virtual void			Query(
								PGPFilterRef		inFilterRef,
								PGPKeyDBRef *		outFoundKeys);
	virtual void			Upload(PGPKeyUploadPreference inSendPrivateKeys,
								PGPKeySetRef inKeysToUpload,
								PGPKeySetRef * outKeysThatFailed);
	virtual void			Delete(PGPKeySetRef inKeysToDelete,
								PGPKeySetRef * outKeysThatFailed);
	virtual void			Disable(PGPKeySetRef inKeysToDelete,
								PGPKeySetRef * outKeysThatFailed);
	virtual void			GetAccessType( PGPKeyServerAccessType &outAccessType )
							{ 
								outAccessType = mAccessType;
							}
								
protected:
	PGPContextRef			mContext;
	PGPKeyServerAccessType	mAccessType;
	PGPldapContextRef		mLDAP;
	char *					mBaseKeySpaceDN;
	PGPExportFormat			mExportFormat;
	
};



#endif /* ] Included_CLDAPPGPKeyServer_h */


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
